#### STEP 1: The Problem ####

# Set parameters that can be changed
	#Basics and preliminaries
		require(MASS)
		n<-100 # number of observations
		numgroups<-10 # Number of groups (higher levels)
		numsims<-1000 # Number of simulations to run

	# Parameters for individual models
		b0<-1 # Intercept
		b1<-0 # Slope on individual level covariate
		sigma<-1 # Sigma, the standard deviation of the regression

	# Parameters for the group level model
		a0<-1 # Intercept for groups
		a1<-0 # Group level covariate
		sigmaG<-1 # Standard deviation of group level stochastic component

	# Set GroupID's
		GroupID<-rep(1:numgroups,length.out=n)

	# Set up results matrix
		Results<-array(NA,dim=c(numsims,6))
		colnames(Results)<-c("Intercept","X1","Z1","sigma","X1 Pvalue","Z1 Pvalue")

#
for(i in 1:numsims){
	# Generate covariates and associated errors
	# Group and individual covariates uncorrelated
		z1G<-rnorm(numgroups,sd=sigmaG)
		z1<-z1G[GroupID]
		x1<-sapply(z1,function(x){rnorm(n=1,mean=x)})		
		#cor(x1,z1)
		#plot(x1,z1)

		IndividualErrors<-rnorm(n,mean=0,sd=sigma)
		StateErrors<-rnorm(numgroups)[GroupID]

	# Generate dependent variable
		lambda<-a0 + a1*z1 + StateErrors
		y<-b0+b1*x1+lambda+IndividualErrors
	# Save Results
		# Basic Regression
		fit1<-lm(y~x1+z1)
		Results[i,1:3]<-fit1$coef
		Results[i,"sigma"]<-summary(fit1)$sigma
		Results[i,c("X1 Pvalue","Z1 Pvalue")]<-summary(fit1)$coefficients[2:3,4]
}

par(mfrow=c(2,3))
#plot(x1,y,col=GroupID,pch=19,main="X1 versus Y1",sub="Colors Denote Groups")
Title<-c("Intercept","Slope on X1","Slope on Z1","Sigma","P-value for x1","P-value for x2")
TrueValue <-c(b0,b1,a1,sigma,NA,NA)
XLAB<-c("Intercept","b1-hat","b2-hat","sigma-hat","P-value","P-Value")
for(i in 1:6){
	hist(Results[,i],nclass=20,main=Title[i],xlab=XLAB[i],sub=paste("Parameter=",TrueValue[i]))
}
print(paste("The percentage of simulations where X1 was significant at the .05 level was:",sum(Results[,5]<.05)/numsims),sep="")
print(paste("The percentage of simulations where Z1 was significant at the .05 level was:",sum(Results[,6]<.05)/numsims),sep="")


